#include <QtGui>

#include "ConnectionForm.h"
#include "MainForm.h"
#include "tableRelationDlg.h"
#include "DatabaseTree.h"

tableRelationDlg::tableRelationDlg(QWidget *parent)
: QDialog(parent)
{
	tableRelaitonPage = new RelationPage();
	
	createData();
	
	connect(this->tableRelaitonPage->relationTables,SIGNAL(activated(const QString &)), this, SLOT(ClickedRelationTable(const QString &)));
	
	applyBtn	= new QPushButton(tr("Ȯ"));
	cancelBtn	= new QPushButton(tr(""));
	
	connect(applyBtn, SIGNAL(clicked()), this, SLOT(ClickApply()));
	connect(cancelBtn, SIGNAL(clicked()), this, SLOT(ClickCancel()));
	
	QHBoxLayout * BtnLayout = new QHBoxLayout;
	BtnLayout->addWidget(applyBtn);
	BtnLayout->addWidget(cancelBtn);
	BtnLayout->setAlignment(Qt::AlignBottom | Qt::AlignCenter);
	
	QVBoxLayout *RelaitonLayout = new QVBoxLayout;
    RelaitonLayout->addWidget(tableRelaitonPage);
	RelaitonLayout->addLayout(BtnLayout);
    setLayout(RelaitonLayout);
	
	setGeometry(0,0,450,300);
	setWindowTitle(tr("̺  ̾α"));
}

void tableRelationDlg::ClickApply()
{
	QMessageBox::StandardButton applyMessage;
	applyMessage = QMessageBox::warning(this, tr("ϱ"),
		tr("  մϴ.\n"
		" Ͻðڽϱ?"),
		QMessageBox::No | QMessageBox::Yes);
	
	if (applyMessage == QMessageBox::Yes)
	{
		QString foreignName = tableRelaitonPage->foriegnkeyName();
		QString selectionTable = tableRelaitonPage->CurrentcomboBoxData(0);
		QString selectionField = tableRelaitonPage->CurrentcomboBoxData(2);
		QString relationTable = tableRelaitonPage->CurrentcomboBoxData(1);
		QString relationField = tableRelaitonPage->CurrentcomboBoxData(3);
		bool integrity = tableRelaitonPage->CurrentCheckBoxState(0);
		bool FieldUpdata	= tableRelaitonPage->CurrentCheckBoxState(1);
		
		qDebug() << selectionField <<":"<<relationField;
		if(selectionField == relationField)
		{
			QString relaitonQuery = tableQueryMaker.relaitonConf(foreignName,selectionTable, 
				selectionField, relationTable, relationField, integrity,FieldUpdata);
			qDebug() << relaitonQuery;
			createTableQuery = QSqlQuery(relaitonQuery);
			
			qDebug() << "Relation Error" << createTableQuery.lastError();
			//createTableQuery.exec();
			
			accept();
		}
		else
		{
			QMessageBox::StandardButton errorMessage;
			errorMessage = QMessageBox::warning(this, tr("ʵ"),
				tr("ʵ尡 ٸϴ. 踦   ϴ.\n"
				"ٽ Ͽ ֽʽÿ."),
				QMessageBox::No | QMessageBox::Yes);
		}
		
		
	}
}

void tableRelationDlg::ClickCancel()
{
	QMessageBox::StandardButton closeMessage;
	closeMessage = QMessageBox::warning(this, tr("ϱ"),
		tr("  ʽϴ.\n"
		" Ͻðڽϱ?"),
		QMessageBox::No | QMessageBox::Yes);
	
	if (closeMessage == QMessageBox::Yes)
	       reject();
}

void tableRelationDlg::createData()
{
	qDebug() << tableQueryMaker.tableNames();
	
	QString selectTableName;
	selectTableName.clear();
	
	QString tableName = ConnectionForm::getInstance()->GetMainForm()->GetFolderView()->currentItem()->text(0);
	
	selectTableName = tableName;
	
	tableRelaitonPage->AddComboBoxData(selectTableName , 0);
	
	qDebug() << tableQueryMaker.columnNames(selectTableName);
	
	createTableQuery = QSqlQuery( tableQueryMaker.columnNames(selectTableName));
	
	while(createTableQuery.next())
	{
		qDebug() << createTableQuery.value(0).toString();
		tableRelaitonPage->AddComboBoxData(createTableQuery.value(0).toString() , 2);
	}	
	
	createTableQuery = QSqlQuery( tableQueryMaker.tableNames());
	
	while(createTableQuery.next())
	{
		qDebug() << createTableQuery.value(0).toString();
		tableRelaitonPage->AddComboBoxData(createTableQuery.value(0).toString() , 1);
	}
}


void tableRelationDlg::ClickedRelationTable(const QString & tableName)
{
	if(tableRelaitonPage->ComboBoxDataCount(3) > 0)
		tableRelaitonPage->RemoveComboBoxAllData(3);
	
	QString relationTableName = tableName;
	qDebug() << "click Query :" << tableName;
	
	createTableQuery = QSqlQuery( tableQueryMaker.columnNames(relationTableName));
	
	while(createTableQuery.next())
	{
		qDebug() << createTableQuery.value(0).toString();
		tableRelaitonPage->AddComboBoxData(createTableQuery.value(0).toString() , 3);
	}
	
}
